var samplePageObj = {
  // 샘플 타이틀
  title: '합계',
  subtitle: '숫자연산과 관련된 전체합계, 컬럼별 합계을 설정할 수 있습니다.',
  // 샘플 설명
  desc: '합계행은 (Cfg, Col, Cell) 별 FormulaRow를 설정하여 표시할 수 있으며, 풋터행을 이용하여 표시할 수도 있습니다.<br>'
    + 'FormulaRow 에는 합계(Sum), 평균(Avg), 최대(Max), 최소(Min) 값등을 예약어로 사용할 수 있습니다.<br>',

  // 객체 초기화 구문
  init: {
    Def: {
      Row: { CanFormula: 1 },
      Col: {
        Width: '150',
        Align: 'Right'
      },
      Foot: {
        CanFormula: 1, // 로우가 정의된 Formula 속성에 따라 계산 될지 여부 설정
        CanEdit: 0,
        CanFocus: 0,
        Color: '#AAAEEB', // 배경색 설정
        HtmlPrefix: '<span style=\'color: #101566; font-weight: bold;\'>', // HtmlPrefix를 셀의 Value 이전에 적용가능
        HtmlPostfix: '</span>' // HtmlPostfix를 셀의 Value 이후에 적용가능
      }

    },
    Cfg: {
      SearchMode: 0,
      PrevColumnMerge: 1,
      DataMerge: 1,
      HeaderMerge: 3,
      SelectionSummary: {
        Mode: 'DelRow',
        Width: 400
      },
      InfoRowConfig: {
        Visible: 1,
        Layout: [
          'SummaryLabel',
          'Count'
        ],
        Space: 'Top'
      }// 건수 정보 표시
    },

    Cols: [
      {
        Header: [
          '정책사업',
          '정책사업'
        ],
        Type: 'Text',
        Name: 'sPolicy',
        Width: '120',
        Align: 'Center',
        CanEdit: 0,
        FormulaRow: '합계행',
        Format: ''
      },
      {
        Header: [
          '단위사업',
          '단위사업'
        ],
        Type: 'Text',
        Name: 'sUnit',
        Width: '180',
        Align: 'Left',
        FormulaRow: 'Count',
        Format: ''
      },
      {
        Header: [
          '세부사업',
          '세부사업'
        ],
        Type: 'Text',
        Name: 'sDetail',
        MinWidth: '200',
        RelWidth: 1,
        Align: 'Left',
        FormulaRow: 'Sum',
        Format: ''
      },

      {
        Header: [
          '예산현액(A)',
          '예산현액(A)'
        ],
        Type: 'Int',
        Name: 'A',
        FormulaRow: 'Sum',
        Format: '#,##0'
      },
      {
        Header: [
          '지출액',
          '전일까지(B)'
        ],
        Type: 'Int',
        Name: 'B',
        Format: '#,##0',
        FormulaRow: 'Avg'
      },
      {
        Header: [
          '지출액',
          '당일(C)'
        ],
        Type: 'Int',
        Name: 'C',
        Format: '#,##0',
        FormulaRow: 'Max'
      },
      {
        Header: [
          '지출액',
          '누계(D)\n(B+C)'
        ],
        Type: 'Int',
        Name: 'D',
        Formula: 'B+C',
        Format: '#,##0 \\원',
        FormulaRow: 'Min'
      },
      {
        Header: [
          '집행률\n(D/A)',
          '집행률\n(D/A)'
        ],
        Type: 'Float',
        Name: 'E',
        Formula: '(isNaN(D/A) || !isFinite(D / A)) ? 0 : D/A',
        Format: '##0.00 \\%',
        FormulaRow: ''
      },
    ],
    // 시트 테이블 하단 Foot 영역을 사용할 경우 설정
    Foot: [
      { // Foot 영역의 첫번 째 로우
        Def: 'Foot', // Def에 설정된 Foot 속성을 적용
        sPolicy: { Value: 'Total' },
        sUnit: {
          Value: '건수',
          Format: ''
        },
        sDetail: { Value: '' },
        A: {
          Type: 'Text',
          Format: '',
          Value: '(A)합계',
          Align: 'center'
        },
        B: {
          Type: 'Text',
          Format: '',
          Value: '(B)평균',
          Align: 'center'
        },
        C: {
          Type: 'Text',
          Format: '',
          Value: '(C)최대',
          Align: 'center'
        },
        D: {
          Type: 'Text',
          Format: '',
          Value: '(D)최소',
          Align: 'center',
          Formula: ''
        },
        E: {
          Type: 'Text',
          Format: '',
          Value: '빈값',
          Align: 'center',
          Formula: ''
        }
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      sPolicy: '인적자원운용',
      sUnit: '정규직인건비',
      sDetail: '교원인건비',
      A: '3530855848000',
      B: '1904204573440',
      C: '19847770130',
      D: '1924052343570'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '정규직인건비',
      sDetail: '지방공무원인건비',
      A: '461430193000',
      B: '247492523010',
      C: '2628843840',
      D: '1924052343570'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '비정규직인건비',
      sDetail: '계약제교원인건비',
      A: '194234361000',
      B: '110681334570',
      C: '1160516120',
      D: '111841850690'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '비정규직인건비',
      sDetail: '계약제직원인건비',
      A: '7018400000',
      B: '3443668820',
      C: '2340000',
      D: '3446008820'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '교원역량강화',
      sDetail: '교원연수지원',
      A: '2971246000',
      B: '2346726550',
      C: '0',
      D: '2346726550'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '교원역량강화',
      sDetail: '교원연수운영',
      A: '2739113250',
      B: '1502240580',
      C: '0',
      D: '1502240580'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '지방공무원역량강화',
      sDetail: '지방공무원연수지원',
      A: '442570000',
      B: '283276930',
      C: '0',
      D: '283276930'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '지방공무원역량강화',
      sDetail: '지방공무원연수운영',
      A: '1169109000',
      B: '485450400',
      C: '0',
      D: '485450400'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '교원인사관리',
      sDetail: '교원임용관리',
      A: '3215238000',
      B: '1153427870',
      C: '0',
      D: '1153427870'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교육과정개발운영',
      sDetail: '교육과정운영',
      A: '11281630000',
      B: '10060625060',
      C: '6620000',
      D: '10067245060'
    },

    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교육과정개발운영',
      sDetail: '교과자료개발보급',
      A: '144355000',
      B: '30621200',
      C: '0',
      D: '30621200'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교육과정개발운영',
      sDetail: '창의인성교육운영',
      A: '280820000',
      B: '159620000',
      C: '0',
      D: '159620000'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교육과정개발운영',
      sDetail: '특색교육과정운영',
      A: '61843186000',
      B: '47466168040',
      C: '0',
      D: '47466168040'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '학력신장',
      sDetail: '학력향상지원',
      A: '2151934790',
      B: '1974256790',
      C: '0',
      D: '1974256790'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '수업지원장학활동',
      sDetail: '현장중심장학활동지원',
      A: '12478023000',
      B: '9582538400',
      C: '0',
      D: '9582538400'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '수업지원장학활동',
      sDetail: '수석교사제운영',
      A: '1454771000',
      B: '1201380000',
      C: '0',
      D: '1201380000'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '연구시범학교운영',
      sDetail: '연구시범학교운영',
      A: '1669450000',
      B: '1668610000',
      C: '0',
      D: '1668610000'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교과교육연구회운영활성화',
      sDetail: '교과교육연구회지원',
      A: '256589000',
      B: '157835280',
      C: '880000',
      D: '158715280'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '유아교육진흥',
      sDetail: '유아교육지원',
      A: '2193337700',
      B: '1094969250',
      C: '0',
      D: '1094969250'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '유아교육진흥',
      sDetail: '유치원방과후과정운영',
      A: '3635250000',
      B: '3041490000',
      C: '30000000',
      D: '3071490000'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '진로진학교육',
      sDetail: '진로진학교육',
      A: '4256580000',
      B: '2655569820',
      C: '150000000',
      D: '2805569820'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '학력평가',
      sDetail: '학력평가관리',
      A: '10215307000',
      B: '6955042810',
      C: '0',
      D: '6955042810'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '학비지원',
      sDetail: '저소득층자녀학비지원',
      A: '36624646500',
      B: '24655662500',
      C: '0',
      D: '24655662500'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '학비지원',
      sDetail: '특성화고장학금지원',
      A: '48897776000',
      B: '25290259340',
      C: '0',
      D: '25290259340'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '학비지원',
      sDetail: '기타교육비지원',
      A: '1285680000',
      B: '375361880',
      C: '0',
      D: '375361880'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '학비지원',
      sDetail: '교육급여지원',
      A: '62723206000',
      B: '23145348100',
      C: '0',
      D: '23145348100'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '방과후등교육지원',
      sDetail: '방과후학교운영',
      A: '51017336000',
      B: '37993758710',
      C: '0',
      D: '37993758710'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '방과후등교육지원',
      sDetail: '저소득층자녀방과후자유수강권지원',
      A: '25984800000',
      B: '15993135800',
      C: '0',
      D: '15993135800'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '급식지원',
      sDetail: '학기중급식비지원',
      A: '35611522000',
      B: '20722200000',
      C: '0',
      D: '20722200000'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '급식지원',
      sDetail: '토·공휴일중식지원',
      A: '5651532000',
      B: '3689453000',
      C: '0',
      D: '3689453000'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '정보화지원',
      sDetail: '정보화지원',
      A: '5646158000',
      B: '2089439330',
      C: '0',
      D: '2089439330'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '교육복지우선지원',
      sDetail: '교육복지우선지원',
      A: '43951618000',
      B: '32766707740',
      C: '2889480',
      D: '32769597220'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '누리과정지원',
      sDetail: '누리과정지원',
      A: '384128770000',
      B: '305151702500',
      C: '0',
      D: '305151702500'
    }
  ]

};
